:@echo off

echo The collection process has started. 

rem Move to the current directory. 
cd /d %~dp0

:: Check WMIC is available
WMIC.EXE Alias /? >NUL 2>&1 || GOTO s_error


for /f "tokens=2 delims==" %%a in ('wmic OS Get localdatetime /value') do set "dt=%%a"
set "YY=%dt:~2,2%" & set "YYYY=%dt:~0,4%" & set "MM=%dt:~4,2%" & set "DD=%dt:~6,2%"
set "HH=%dt:~8,2%" & set "Min=%dt:~10,2%" & set "Sec=%dt:~12,2%"

set "DATETIME=%YYYY%%MM%%DD%-%HH%%Min%%Sec%-%ComputerName%"

GOTO makefolder

:s_error
echo WMIC is not available, using default log filename
Set DATETIME=default-%ComputerName%

:makefolder

set EVENTLOGPATH=.\Log_%DATETIME%\eventlogs

rem ======================== Event log collection  ===========================
rem ===== Collect all major logs  =====
mkdir %EVENTLOGPATH%
wevtutil epl "Application" %EVENTLOGPATH%\Application.evtx
wevtutil epl "Security" %EVENTLOGPATH%\Security.evtx
wevtutil epl "Setup" %EVENTLOGPATH%\Setup.evtx
wevtutil epl "System" %EVENTLOGPATH%\System.evtx
wevtutil epl "Microsoft-Windows-International-RegionalOptionsControlPanel/Operational" /q: %EVENTLOGPATH%\Operational.evtx 

rem ================== Check if you can run as administrator  ==================
rem If the information "Security" that can only be obtained by the administrator is not available, pause is used to warn. 
if not exist %EVENTLOGPATH%\Security.evtx (
echo You do not have administrator privileges. Run as administrator again! 
rmdir /S /Q .\Log_%DATETIME%
pause
exit
)

rem ===================== Under Log folder  =========================
set DEBUGLOGPATH=.\Log_%DATETIME%\Log
if exist "C:\LabSolutions\Log" (
	mkdir %DEBUGLOGPATH%
	xcopy "C:\LabSolutions\Log" "%DEBUGLOGPATH%" /Y /E /I /D
)

rem ===================== Other information collection  =========================
rem System information 
set OTHERINFOPATH=.\Log_%DATETIME%\otherinfo
mkdir %OTHERINFOPATH%
rem power settings of current user  
powercfg /QH >  %OTHERINFOPATH%\PowerPlanSetting.txt

rem get info of all services 
sc queryex type=service state=all > %OTHERINFOPATH%\ServicesAll.txt

systeminfo >%OTHERINFOPATH%\systeminfo.txt
rem WindowsUpdate Information acquisition 
reg query "HKLM\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate" /s > %OTHERINFOPATH%\reg-windowsupdate.txt
rem Uninstall Registry information acquisition 
reg query "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall" /s > %OTHERINFOPATH%\reg-uninsallreginfo.txt
reg query "HKLM\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall" /s > %OTHERINFOPATH%\reg-uninsallreginfo-wow6432.txt

rem Language Settings Current User
reg query "HKEY_CURRENT_USER\Control Panel\International" /s > %OTHERINFOPATH%\reg-current-user-settings.txt

rem default printer settings
reg query "HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Windows" /s > %OTHERINFOPATH%\reg-default-printer-settings.txt

rem Language Settings Welcome Screen, System
reg query "HKEY_USERS\.DEFAULT\Control Panel\International" /s > %OTHERINFOPATH%\reg-default-user-settings.txt
reg query "HKEY_USERS\S-1-5-18\Control Panel\International" /s > %OTHERINFOPATH%\reg-local-sysem-ID-settings.txt
reg query "HKEY_USERS\S-1-5-19\Control Panel\International" /s > %OTHERINFOPATH%\reg-NT-Authority-settings.txt
reg query "HKEY_USERS\S-1-5-20\Control Panel\International" /s > %OTHERINFOPATH%\reg-Network-Service-settings.txt


rem MSI log and log files in temp folder 
set TEMPPATH=%OTHERINFOPATH%\tmpMSILog
mkdir %TEMPPATH%
xcopy %tmp%\MSI* %TEMPPATH%\ /R /Y /C

rem Installation file list 
rem Get the file list for% ProgramFiles (x86)% \ LabSolutions and C: \ LabSolutions  
if exist "%ProgramFiles(x86)%\LabSolutions" (
	dir /b /s "%ProgramFiles(x86)%\LabSolutions" > %OTHERINFOPATH%\files-ProgramFilesLabSolutoins.txt
)
if exist "%ProgramFiles%\LabSolutions" (
	dir /b /s "%ProgramFiles%\LabSolutions" > %OTHERINFOPATH%\files-ProgramFilesLabSolutoins-32bit.txt
)
if exist "C:\LabSolutions" (
	dir /b /s "C:\LabSolutions" > %OTHERINFOPATH%\files-LabSolutoins.txt
)

rem dinfo / sinfo collection
if exist "%ProgramFiles(x86)%\LabSolutions" (
	xcopy "%ProgramFiles(x86)%\LabSolutions\*.dinfo" %OTHERINFOPATH% /Y /I /D
	xcopy "%ProgramFiles(x86)%\LabSolutions\*.sinfo" %OTHERINFOPATH% /Y /I /D
)

rem Get the folder name list of C drive (only directly under C drive) 
dir c:\ /b > %OTHERINFOPATH%\cdrive-foldername.txt

rem Retrieval of C: \ LabSolutions \ LSSSystemInformation.ini 
if exist "C:\LabSolutions\System\LSSSystemInformation.ini" (
	xcopy "C:\LabSolutions\System\LSSSystemInformation.ini" %OTHERINFOPATH% /Y /I /D
) 

rem Collect C: \ LabSolutions \ System \ config \ LSSDbConnectionConfiguration.xml 
if exist "C:\LabSolutions\System\config\LSSDbConnectionConfiguration.xml" (
	xcopy "C:\LabSolutions\System\config\LSSDbConnectionConfiguration.xml" %OTHERINFOPATH% /Y /I /D
) 

rem Lab Solutions Registry List 
reg query "HKLM\SOFTWARE\Wow6432Node\SHIMADZU" /s > %OTHERINFOPATH%\reg-labsolutionsinfo.txt

rem Whether there is something in the Virtual store
set VIRTUALSTOREINPUT=%appdata%\..\Local\VirtualStore\Program Files (x86)\LabSolutions
dir /b /s "%VIRTUALSTOREINPUT%" > %OTHERINFOPATH%\files-VirtualStore.txt

rem OEM file and log set in inf folder 
set OEMPATH=%OTHERINFOPATH%\Inf-Oem
mkdir %OEMPATH%
xcopy C:\Windows\inf\oem* %OEMPATH%\ /R /Y /C
xcopy C:\Windows\inf\*.log %OEMPATH%\ /R /Y /C

rem SQLServer 2017 installation log 
set SQLSERVERLOGFOLDER="%ProgramFiles%\Microsoft SQL Server\140\Setup Bootstrap\Log"
if exist %SQLSERVERLOGFOLDER% (
	mkdir "%OTHERINFOPATH%\Microsoft SQL Server\140\Setup Bootstrap\Log"
	xcopy %SQLSERVERLOGFOLDER% "%OTHERINFOPATH%\Microsoft SQL Server\140\Setup Bootstrap\Log" /Y /E /I /D
)

rem SQLServer 2014 installation log  
set SQLSERVERLOGFOLDER="%ProgramFiles%\Microsoft SQL Server\120\Setup Bootstrap\Log"
if exist %SQLSERVERLOGFOLDER% (
	mkdir "%OTHERINFOPATH%\Microsoft SQL Server\120\Setup Bootstrap\Log"
	xcopy %SQLSERVERLOGFOLDER% "%OTHERINFOPATH%\Microsoft SQL Server\120\Setup Bootstrap\Log" /Y /E /I /D
)
rem SQLServer 2008 installation log
set SQLSERVERLOGFOLDER="%ProgramFiles%\Microsoft SQL Server\100\Setup Bootstrap\Log"
if exist %SQLSERVERLOGFOLDER% (
	mkdir "%OTHERINFOPATH%\Microsoft SQL Server\100\Setup Bootstrap\Log"
	xcopy %SQLSERVERLOGFOLDER% "%OTHERINFOPATH%\Microsoft SQL Server\100\Setup Bootstrap\Log" /Y /E /I /D
)

rem Windows.old information 
set WINDOWSOLDEVENTLOGFOLDER="C:\Windows.old\Windows\System32\winevt\Logs"
if exist %WINDOWSOLDEVENTLOGFOLDER% (
	mkdir "%OTHERINFOPATH%\Windows.old\Windows\System32\winevt\Logs"
	xcopy %WINDOWSOLDEVENTLOGFOLDER%\Application.evtx "%OTHERINFOPATH%\Windows.old\Windows\System32\winevt\Logs" /Y /E /I /D
	xcopy %WINDOWSOLDEVENTLOGFOLDER%\System.evtx "%OTHERINFOPATH%\Windows.old\Windows\System32\winevt\Logs" /Y /E /I /D
	xcopy %WINDOWSOLDEVENTLOGFOLDER%\Setup.evtx "%OTHERINFOPATH%\Windows.old\Windows\System32\winevt\Logs" /Y /E /I /D
	xcopy %WINDOWSOLDEVENTLOGFOLDER%\Security.evtx "%OTHERINFOPATH%\Windows.old\Windows\System32\winevt\Logs" /Y /E /I /D
)
set WINDOWSOLD-SQLLOGFOLDER140="C:\Windows.old\Program Files\Microsoft SQL Server\140\Setup Bootstrap\Log"
if exist %WINDOWSOLD-SQLLOGFOLDER140% (
	mkdir "%OTHERINFOPATH%\Windows.old\Program Files\Microsoft SQL Server\140\Setup Bootstrap\Log"
	xcopy %WINDOWSOLD-SQLLOGFOLDER140% "%OTHERINFOPATH%\Windows.old\Program Files\Microsoft SQL Server\140\Setup Bootstrap\Log" /Y /E /I /D
)
set WINDOWSOLD-SQLLOGFOLDER120="C:\Windows.old\Program Files\Microsoft SQL Server\120\Setup Bootstrap\Log"
if exist %WINDOWSOLD-SQLLOGFOLDER120% (
	mkdir "%OTHERINFOPATH%\Windows.old\Program Files\Microsoft SQL Server\120\Setup Bootstrap\Log"
	xcopy %WINDOWSOLD-SQLLOGFOLDER120% "%OTHERINFOPATH%\Windows.old\Program Files\Microsoft SQL Server\120\Setup Bootstrap\Log" /Y /E /I /D
)
set WINOLD-PROGRAMFILES-LABSOLFOLDER64="C:\Windows.old\Program Files (x86)\LabSolutions"
if exist %WINOLD-PROGRAMFILES-LABSOLFOLDER64% (
	mkdir "%OTHERINFOPATH%\Windows.old\Program Files (x86)\LabSolutions"
	xcopy %WINOLD-PROGRAMFILES-LABSOLFOLDER64%\*.dinfo "%OTHERINFOPATH%\Windows.old\Program Files (x86)\LabSolutions" /Y /I /D
	xcopy %WINOLD-PROGRAMFILES-LABSOLFOLDER64%\*.sinfo "%OTHERINFOPATH%\Windows.old\Program Files (x86)\LabSolutions" /Y /I /D
)

rem ===================== compression =========================
set ZIPINPUTPATH= .\Log_%DATETIME%
set ZIPTARGETPATH= .\Log_%DATETIME%.zip
.\7zip-cmd\7za.exe a %ZIPTARGETPATH% %ZIPINPUTPATH%

rmdir /S /Q .\Log_%DATETIME%

rem revision history
rem installlogtoolv113 orginal from japan
rem added power settings of current user
rem added wevtutil epl "Microsoft-Windows-International-RegionalOptionsControlPanel/Operational" /q: %EVENTLOGPATH%\Operational.evtx 
rem Language Settings Current User
rem Language Settings Welcome Screen, System
rem added all Services running, stopped, starting 
rem added default printer settings
rem SQLServer 2008 setup log added 
rem zip file name contains date time and computername; collection folder is deleted at the end; if the tool is executed without admin privileges it will terminate
rem echo off removed from script at the beginning to fix an issue that the tool was not runing on some systems 
rem fixed a bug that prevent the folder name to be generated when running on a PC that does not English US date format